unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
//A pontszm 4+3*k kell legyen
const pontszam=19;
var
  Form1: TForm1;
  //A pontok tmbje
  Pontok : Array [0..pontszam-1] of TPoint;
  //A kivlasztott pont mozgathat
  kivalasztott:integer;


implementation

{$R *.DFM}
function Pontkeres(x,y:integer):integer;
// A fggvny kikeresi az x,y ponthoz legkzelebbi sarokpontot
var tav,tav1,tav2,tav12:real;
    i:integer;
begin
   tav:=10000;
   Pontkeres:=-1;
   for i:=0 to pontszam-1 do
     begin
       tav1:=(Pontok[i].x-x);
       tav2:=(Pontok[i].y-y);
       tav1:=tav1*tav1;
       tav2:=tav2*tav2;
       tav12:=tav1+tav2;
       if tav12<tav then
         begin
           tav:=tav12;
           Pontkeres:=i;
         end;
     end;
end;
procedure TForm1.FormCreate(Sender: TObject);
var xk, yk, r, i:integer;
begin
   // Ltrehozzuk az alapbra pontjait
   xk:=ClientWidth div 2;
   yk:=ClientHeight div 2;
   r:=ClientHeight div 3;
   for i:=0 to pontszam-2 do
    begin
     Pontok[i].x:=xk+Trunc(r*cos(i/(pontszam-1)*6.28));
     Pontok[i].y:=yk+Trunc(r*sin(i/(pontszam-1)*6.28));
    end;
   //Az els s utols pont azonos
   Pontok[pontszam-1].x:=Pontok[0].x;
   Pontok[pontszam-1].y:=Pontok[0].y;
   kivalasztott:=-1;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  // Kifestskor a tartpontok poligonja fekete
  Canvas.Pen.Color:=clBlack;
  Canvas.Polyline(Pontok);
  // Kifestskor a Bezier grbk pirosak
  Canvas.Pen.Color:=clRed;
  Canvas.PolyBezier(Pontok);
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  //Gombnyomssal pontot vlasztunk
  kivalasztott:=Pontkeres(x,y);
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  // Ha elengedjk az egrgombot nincs kivlasztott pont
  kivalasztott:=-1;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   // Ha van kivlasztott pont (lenyomott egrgomb), akkor az mozog
   if (kivalasztott>-1) then
     begin
       if (kivalasztott<>0) and (kivalasztott<>pontszam-1) then
        begin
         Pontok[kivalasztott].x:=x;
         Pontok[kivalasztott].y:=y;
        end
       else
        begin
         //Az els s utols pont azonos
         Pontok[0].x:=x;
         Pontok[0].y:=y;
         Pontok[pontszam-1].x:=x;
         Pontok[pontszam-1].y:=y;
        end;
      Refresh;
     end;
end;

end.
